<?php

$choolidse = Yii::app()->user->getState('schoolId');
$schoolId = (Yii::app()->user->role == 'schoolAdmin' && !empty($choolidse)) ? Yii::app()->user->getState('schoolId') : $model->schoolId;

Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/admin/main.js');
Yii::app()->clientScript->registerScript('studentForm', '
	function showLoadingClasses()
	{
		$("#classes").prev("span").fadeIn();
		$("#classes").fadeOut();
	}

	function hideLoadingClasses()
	{
		$("#classes").prev("span").fadeOut();
		$("#classes").fadeIn();
	}

	 //pobieranie klas na podstawie szkoly, nastepnie wyswietlanie w selectcie i wywolywanie getCompanies
	function getClasses(schoolId, classId)
	{
		//brak id szkoly - wyswietlanie pusty select
		if(schoolId == undefined || schoolId.length==0)
		{
			hideLoadingClasses();
			return;
		}

		showLoadingClasses();
		$.get("'.Yii::app()->createUrl('administration/uzytkownik/getClassesBySchool').'", { schoolId: schoolId })
		.done(function(data) {
			var classes = jQuery.parseJSON(data);
			var htmlString = "<option>Wybierz klasę</option>";
			for(var i=0;i<classes.length;i++)
			{
				htmlString += "<option value = \""+classes[i].id+"\"";
				if(classId != undefined && classId == classes[i].id)
					htmlString += " selected=\"selected\""
				htmlString += ">"+classes[i].nazwa+"</option>";
			}
			hideLoadingClasses();
			$("#classes").html(htmlString);
		});
	}

	$("#Firma_schoolId").change(function(){
		getClasses($(this).val());
	});

	//ustawianie danych na podstawie modelu
	var classId = "'.$model->idKlasy.'";
	var schoolId = "'.$schoolId.'";

	//ustawianie wartosci na podstawie modelu
	getClasses(schoolId,classId);

', CClientScript::POS_READY); ?>

<style type="text/css">
	#generateNip, #generateRegon {
		vertical-align: middle;
		height: 20px;
		margin-bottom: 5px;
		cursor: pointer;
	}
</style>

<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'firma-form',
	'enableAjaxValidation'=>false,
)); ?>

	<div class="row">
		<?php echo $form->labelEx($model,'nazwa'); ?>
		<?php echo $form->textField($model,'nazwa',array('size'=>60,'maxlength'=>128)); ?>
		<?php echo $form->error($model,'nazwa'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'nip'); ?>
		<?php echo $form->textField($model,'nip',array('size'=>60,'maxlength'=>128)); ?>
		<img title="Generuj" alt="Generuj" id="generateNip" src="<?php echo Yii::app()->baseUrl; ?>/images/gui/button_wizard.png" />
		<?php echo $form->error($model,'nip'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'regon'); ?>
		<?php echo $form->textField($model,'regon',array('size'=>60,'maxlength'=>128)); ?>
		<img title="Generuj" alt="Generuj" id="generateRegon" src="<?php echo Yii::app()->baseUrl; ?>/images/gui/button_wizard.png" />
		<?php echo $form->error($model,'regon'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'urlLogo'); ?>
		<?php echo $form->textField($model,'urlLogo',array('size'=>60,'maxlength'=>512)); ?>
		<?php echo $form->error($model,'urlLogo'); ?>
	</div>

	<?php if(!$model->isNewRecord): ?>
		<div class="row">
			<ul>
				<?php foreach($students as $student): ?>
				<li><?php echo $student->imie.' '.$student->nazwisko ?> | <a href="<?php echo $this->createUrl('uzytkownik/update', array('id'=>$student->id)) ?>">Edytuj ucznia</a></li>
				<?php endforeach; ?>
			</ul>
		</div>
	<?php endif; ?>

	<div class="row">
		<?php echo $form->labelEx($model,'idDziedziny'); ?>
		<?php echo $form->dropDownList($model,'idDziedziny',array(''=>'Wybierz dziedzinę')+CHtml::listData(Dziedzina::model()->findAll('"id" NOT IN (5,6)'),'id','nazwa')); ?>
		<?php echo $form->error($model,'idDziedziny'); ?>
	</div>

<?php if(!isset($_GET['userId'])): ?>
	<div class="row">
		<?php echo $form->labelEx($model, 'schoolId'); ?>
<?php if(Yii::app()->user->role == 'admin'): ?>
		<?php echo $form->dropDownList($model, 'schoolId', array(''=>'Wybierz szkołę')+CHtml::listData($schools, 'id', 'nazwa')); ?>
<?php else: ?>
		<?php echo CHtml::dropDownList('Firma[schoolId]', Yii::app()->user->getState('schoolId'), CHtml::listData($schools, 'id', 'nazwa'), array('id'=>'Firma_schoolId', 'disabled'=>'disabled')) ?>
<?php endif; ?>
		<?php echo $form->error($model,'schoolId'); ?>
	</div>
	<div class="row">
		<?php echo $form->labelEx($model,'idKlasy'); ?>
		<span>
			<img style="vertical-align:middle" class="smallLoader" src="<?php echo Yii::app()->baseUrl ?>/images/loader.gif" />
			Proszę czekać, wczytywanie...
		</span>
		<select name="Firma[idKlasy]" id="classes" style="display:none;vertical-align:middle">
			<option value="">Wybierz klasę</option>
		</select>
		<?php echo $form->error($model,'idKlasy'); ?>
	</div>
<?php endif; ?>
	<div class="row buttons">
		<?php echo CHtml::submitButton($model->isNewRecord ? 'Dodaj' : 'Zapisz',array('class'=>'buttonS bLightBlue')); ?>
	</div>

<?php $this->endWidget(); ?>

</div>

<script type="text/javascript">
(function()
{
	$('#generateNip').click(function(){
		$('#Firma_nip').val(generateNip());
	});
	$('#generateRegon').click(function(){
		$('#Firma_regon').val(generateRegon9());
	});
})();
</script>
